package cn.geminis.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

/**
 * @author Allen
 */
public class FileUtils {

    public static void writeFile(String filename, byte[] data) {
        var file = new File(filename);
        if (!file.exists() && file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }


        try (var stream = new FileOutputStream(filename)) {
            stream.write(data);
        } catch (Exception e) {
            throw new RuntimeException("将数据写入文件错误", e);
        }
    }

    public static byte[] readFile(String filename) {
        var file = new File(filename);
        if (!file.exists()) {
            return null;
        }

        var fileLen = (int) file.length();
        var data = new byte[fileLen];

        try (var stream = new FileInputStream(file)) {
            stream.read(data);
            return data;
        } catch (Exception e) {
            throw new RuntimeException("读取文件错误", e);
        }
    }
}
