package cn.geminis.fabric.core.client;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @author Allen
 */
@FeignClient(value = "fabric", path = "/chaincode", primary = false)
public interface ChaincodeClient {

    /**
     * 数据上链
     *
     * @param channel   通道ID
     * @param chaincode 链码名称
     * @param id        数据ID
     * @param value     数据内容
     */
    @PutMapping("/{channel}/{chaincode}/{id}")
    void set(@PathVariable("channel") String channel,
             @PathVariable("chaincode") String chaincode,
             @PathVariable("id") String id,
             @RequestBody String value);

    /**
     * 获取数据
     *
     * @param channel 通道ID
     * @param chaincode 链码名称
     * @param id 数据ID
     * @return 数据内容
     */
    @GetMapping("/{channel}/{chaincode}/{id}")
    String get(@PathVariable("channel") String channel,
               @PathVariable("chaincode") String chaincode,
               @PathVariable("id") String id);

    /**
     * 删除数据
     *
     * @param channel 通道ID
     * @param chaincode 链码名称
     * @param id 数据ID
     */
    @DeleteMapping("/{channel}/{chaincode}/{id}")
    void delete(@PathVariable("channel") String channel,
                @PathVariable("chaincode") String chaincode,
                @PathVariable("id") String id);

}
