package cn.geminis.fabric.core.client;

import cn.geminis.fabric.core.model.BlockInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * @author puddi
 */
@FeignClient(value = "fabric", path = "/block", primary = false)
public interface BlockClient {

    /**
     * 获取区块链信息
     *
     * @param channel 通道ID
     * @param chaincode 链码名称
     * @param id 数据ID
     * @return 区块信息
     */
    @GetMapping("/{channel}/{chaincode}/{id}")
    BlockInfo get(@PathVariable("channel") String channel,
                  @PathVariable("chaincode") String chaincode,
                  @PathVariable("id") String id);

}
