package cn.geminis.crypto.ocsp;

import org.bouncycastle.asn1.ocsp.OCSPResponse;

import java.math.BigInteger;

public class OcspResponse {

    private BigInteger result;

    public BigInteger getResult() {
        return result;
    }

    public OcspResponse(byte[] data) {
        OCSPResponse response = OCSPResponse.getInstance(data);
        result = response.getResponseStatus().getValue();
    }

    public boolean checkResult() {
        return result.equals(BigInteger.ZERO);
    }

}
