package cn.geminis.crypto.csp.soft.rsa;

import cn.geminis.crypto.core.key.PrivateKey;
import cn.geminis.crypto.core.key.PublicKey;
import cn.geminis.crypto.csp.soft.AbstractSoftSigner;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.signers.RSADigestSigner;

/**
 * @author Allen
 */
public class Sha1WithRsaSigner extends AbstractSoftSigner {

    public Sha1WithRsaSigner(PublicKey publicKey, PrivateKey privateKey) {
        super(publicKey, privateKey);
    }

    @Override
    protected org.bouncycastle.crypto.Signer createSigner() {
        return new RSADigestSigner(new SHA1Digest());
    }

    @Override
    public String getAlgOid() {
        return PKCSObjectIdentifiers.sha1WithRSAEncryption.toString();
    }

    @Override
    public String getDigestAlgOid() {
        return OIWObjectIdentifiers.idSHA1.toString();
    }
}
