package cn.geminis.crypto.csp.soft.rsa;

import cn.geminis.crypto.csp.AbstractMac;
import cn.geminis.crypto.csp.parameter.InitMacCipherParameters;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

/**
 * @author Allen
 */
public class Sha1HMac extends AbstractMac {

    private HMac hMac = new HMac(new Sha1Digest());

    @Override
    public void init(InitMacCipherParameters params) {
        hMac.init(new KeyParameter(params.getKey()));
    }

    @Override
    public String getAlgorithmName() {
        return hMac.getAlgorithmName();
    }

    @Override
    public int getMacSize() {
        return hMac.getMacSize();
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        hMac.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        return hMac.doFinal(out, outOff);
    }

    @Override
    public void reset() {
        hMac.reset();
    }

    @Override
    public void close() {

    }
}
