package cn.geminis.crypto.csp.soft.rsa;


import cn.geminis.crypto.csp.soft.AbstractSoftDigest;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.crypto.digests.SHA1Digest;

/**
 * @author Allen
 */
public class Sha1Digest extends AbstractSoftDigest {

    @Override
    protected org.bouncycastle.crypto.Digest createDigest() {
        return new SHA1Digest();
    }

    @Override
    public String getAlgorithmOid() {
        return OIWObjectIdentifiers.idSHA1.toString();
    }
}
