package cn.geminis.crypto.csp.soft.rsa;

import cn.geminis.crypto.core.key.PrivateKey;
import cn.geminis.crypto.core.key.PublicKey;
import cn.geminis.crypto.csp.soft.AbstractSoftAsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.engines.RSAEngine;

/**
 * @author Allen
 */
public class RsaBlockCipher extends AbstractSoftAsymmetricBlockCipher {

    public RsaBlockCipher(PublicKey publicKey, PrivateKey privateKey) {
        super(publicKey, privateKey);
    }

    @Override
    protected AsymmetricBlockCipher createBlockChiper() {
        return new RSAEngine();
    }
}
