package cn.geminis.crypto.csp.soft.rsa;

import cn.geminis.crypto.csp.soft.AbstractSoftBlockCipher;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.engines.AESLightEngine;

/**
 * @author Allen
 */
public class AesBlockCipher extends AbstractSoftBlockCipher {

    public AesBlockCipher(byte[] mainKey) {
        super(mainKey);
    }

    @Override
    protected org.bouncycastle.crypto.BlockCipher createBlockChiper() {
        return new AESLightEngine();
    }

    @Override
    protected String getAlgorithmIdentifier() {
        return NISTObjectIdentifiers.aes.toString();
    }

    @Override
    public int getKeySize() {
        return getBlockSize();
    }
}
