package cn.geminis.crypto.csp.soft.gm;

import cn.geminis.crypto.csp.soft.AbstractSoftBlockCipher;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.crypto.engines.SM4Engine;

/**
 * @author Allen
 */
public class Sm4BlockCipher extends AbstractSoftBlockCipher {

    public Sm4BlockCipher(byte[] mainKey) {
        super(mainKey);
    }

    @Override
    protected org.bouncycastle.crypto.BlockCipher createBlockChiper() {
        return new SM4Engine();
    }

    @Override
    protected String getAlgorithmIdentifier() {
        return GMObjectIdentifiers.sms4_cbc.toString();
    }

    @Override
    public int getKeySize() {
        return 16;
    }
}
