package cn.geminis.crypto.csp.soft.gm;

import cn.geminis.crypto.core.key.PrivateKey;
import cn.geminis.crypto.core.key.PublicKey;
import cn.geminis.crypto.csp.soft.AbstractSoftSigner;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;

/**
 * @author Allen
 */
public class Sm2Signer extends AbstractSoftSigner {

    public Sm2Signer(PublicKey publicKey, PrivateKey privateKey) {
        super(publicKey, privateKey);
    }

    @Override
    protected org.bouncycastle.crypto.Signer createSigner() {
        return new org.bouncycastle.crypto.signers.SM2Signer();
    }

    @Override
    public String getAlgOid() {
        return GMObjectIdentifiers.sm2sign_with_sm3.toString();
    }

    @Override
    public String getDigestAlgOid() {
        return GMObjectIdentifiers.sm3.getId();
    }

}
