package cn.geminis.crypto.csp.soft.gm;

import cn.geminis.crypto.csp.soft.AbstractSoftKeyPairGenerator;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECNamedDomainParameters;

import java.security.SecureRandom;

/**
 * @author Allen
 */
public class Sm2KeyGenerator extends AbstractSoftKeyPairGenerator {

    public Sm2KeyGenerator() {
        var name = "sm2p256v1";
        var oid = ECNamedCurveTable.getOID(name);
        var ecSpec = ECNamedCurveTable.getByName(name);
        var domainParameters = new ECNamedDomainParameters(oid, ecSpec.getCurve(), ecSpec.getG(), ecSpec.getN());
        var generationParameters = new ECKeyGenerationParameters(domainParameters, new SecureRandom());
        this.generator = new ECKeyPairGenerator();
        generator.init(generationParameters);
    }

    @Override
    public String getObjectIdentifier() {
        return "1.2.840.10045.2.1";
    }
}
