package cn.geminis.crypto.csp.soft.empty;

import cn.geminis.crypto.core.key.KeyPair;
import cn.geminis.crypto.core.key.PrivateKey;
import cn.geminis.crypto.core.key.PublicKey;
import cn.geminis.crypto.csp.AbstractSigner;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;

/**
 * @author Allen
 */
public class EmptySigner extends AbstractSigner {

    private PublicKey publicKey;
    private PrivateKey privateKey;

    public EmptySigner(PublicKey publicKey, PrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    @Override
    public String getAlgOid() {
        return PKCSObjectIdentifiers.sha1WithRSAEncryption.toString();
    }

    @Override
    public String getDigestAlgOid() {
        return OIWObjectIdentifiers.idSHA1.toString();
    }

    @Override
    protected KeyPair getKeyPair() {
        return new KeyPair(this.publicKey, this.privateKey);
    }

    @Override
    public void close() {

    }

    @Override
    public void init(boolean b, CipherParameters cipherParameters) {

    }

    @Override
    public void update(byte[] bytes, int i, int i1) {

    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        return new byte[0];
    }

    @Override
    public boolean verifySignature(byte[] bytes) {
        return true;
    }

    @Override
    public void reset() {

    }
}
