package cn.geminis.crypto.csp.soft.empty;

import cn.geminis.crypto.csp.soft.AbstractSoftKeyPairGenerator;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;

import java.math.BigInteger;
import java.security.SecureRandom;

/**
 * @author Allen
 */
public class EmptyKeyGenerator extends AbstractSoftKeyPairGenerator {

    public EmptyKeyGenerator(int moduleLength) {
        RSAKeyGenerationParameters parameters = new RSAKeyGenerationParameters(
                new BigInteger("65535"), new SecureRandom(), moduleLength, 0);
        this.generator = new RSAKeyPairGenerator();
        generator.init(parameters);
    }

    @Override
    public String getObjectIdentifier() {
        return "1.2.840.113549.1.1.1";
    }
}
