package cn.geminis.crypto.csp.soft.empty;


import cn.geminis.crypto.csp.AbstractDigest;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;

/**
 * @author Allen
 */
public class EmptyDigest extends AbstractDigest {

    @Override
    public String getAlgorithmOid() {
        return OIWObjectIdentifiers.idSHA1.toString();
    }

    @Override
    public void close() {

    }

    @Override
    public String getAlgorithmName() {
        return "EmptyDigest";
    }

    @Override
    public int getDigestSize() {
        return 20;
    }

    @Override
    public void update(byte[] bytes, int i, int i1) {
    }

    @Override
    public int doFinal(byte[] bytes, int i) {
        return 20;
    }

    @Override
    public void reset() {

    }
}
