package cn.geminis.crypto.csp.soft.empty;

import cn.geminis.crypto.core.key.PrivateKey;
import cn.geminis.crypto.core.key.PublicKey;
import cn.geminis.crypto.csp.*;
import cn.geminis.crypto.csp.soft.SoftRandomGenerator;
import cn.geminis.crypto.csp.soft.rsa.RsaKeyGenerator;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

/**
 * @author Allen
 */
public class EmptyCspFactory extends AbstractCspFactory {

    private PrivateKey privateKey;
    private PublicKey publicKey;

    public EmptyCspFactory() {
        var generator = new RsaKeyGenerator(1024);
        var keypair = generator.generateKeyPair();

        this.privateKey = keypair.getPrivateKey();
        this.publicKey = keypair.getPublicKey();

        register();
    }

    @Override
    public RandomGenerator createRandomGenerator() {
        return new SoftRandomGenerator();
    }

    @Override
    public String getDigestAlgOid() {
        return OIWObjectIdentifiers.idSHA1.toString();
    }

    @Override
    public String getDigestAlgName() {
        return "SHA1";
    }

    @Override
    public AbstractDigest createDigest() {
        return new EmptyDigest();
    }

    @Override
    public String getSignerAlgOid() {
        return PKCSObjectIdentifiers.sha1WithRSAEncryption.toString();
    }

    @Override
    public String getAsyncEncryptionAlgOid() {
        return PKCSObjectIdentifiers.rsaEncryption.toString();
    }

    @Override
    public String getSignerAlgName() {
        return "Sha1WithRSA";
    }

    @Override
    public AbstractSigner createSigner() {
        return new EmptySigner(publicKey, privateKey);
    }

    @Override
    public AbstractBlockCipher createBlockCipher() {
        return new EmptyBlockCipher();
    }

    @Override
    public AbstractAsymmetricBlockCipher createAsymmetricBlockCipher() {
        return new EmptyAsymmetricBlockCipher(this.publicKey);
    }

    @Override
    public KeyPairGenerator createKeyPairGenerator() {
        return new EmptyKeyGenerator(1024);
    }

    @Override
    public AbstractAgreement createAgreement() {
        return new EmptyAgreement(this.publicKey, this.privateKey);
    }

    @Override
    public AbstractMac createMac() {
        return new EmptyHMac();
    }

    @Override
    public String getBlockCipherAlgOid() {
        return NISTObjectIdentifiers.aes.toString();
    }

    @Override
    public String getKeyPairOid() {
        return "1.2.840.113549.1.1.1";
    }

    @Override
    public void close() {
    }
}
