package cn.geminis.crypto.csp.soft.empty;

import cn.geminis.crypto.csp.AbstractBlockCipher;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;

/**
 * @author Allen
 */
public class EmptyBlockCipher extends AbstractBlockCipher {

    @Override
    public CipherParameters createParams(byte[] key) {
        return null;
    }

    @Override
    protected String getAlgorithmIdentifier() {
        return NISTObjectIdentifiers.aes.toString();
    }

    @Override
    public int getKeySize() {
        return 32;
    }

    @Override
    public void close() {

    }

    @Override
    public void init(boolean b, CipherParameters cipherParameters) throws IllegalArgumentException {

    }

    @Override
    public String getAlgorithmName() {
        return "EmptyBlockCipher";
    }

    @Override
    public int getBlockSize() {
        return 32;
    }

    @Override
    public int processBlock(byte[] bytes, int sourceStart, byte[] target, int targetStart) throws DataLengthException, IllegalStateException {
        System.arraycopy(bytes, sourceStart, target, targetStart, 32);
        return 32;
    }

    @Override
    public void reset() {

    }
}
