package cn.geminis.crypto.csp.soft.empty;

import cn.geminis.core.util.ByteUtils;
import cn.geminis.crypto.core.key.PublicKey;
import cn.geminis.crypto.csp.AbstractAsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;

/**
 * @author Allen
 */
public class EmptyAsymmetricBlockCipher extends AbstractAsymmetricBlockCipher {

    private PublicKey publicKey;

    public EmptyAsymmetricBlockCipher(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public byte[] getPublicKey() {
        return this.publicKey.getEncoded();
    }

    @Override
    public void close() {

    }

    @Override
    public void init(boolean b, CipherParameters cipherParameters) {

    }

    @Override
    public int getInputBlockSize() {
        return 0;
    }

    @Override
    public int getOutputBlockSize() {
        return 0;
    }

    @Override
    public byte[] processBlock(byte[] bytes, int start, int length) {
        return ByteUtils.sub(bytes, start, length);
    }
}
