package cn.geminis.crypto.csp.soft.empty;

import cn.geminis.crypto.core.key.PrivateKey;
import cn.geminis.crypto.core.key.PublicKey;
import cn.geminis.crypto.csp.AbstractAgreement;
import cn.geminis.crypto.csp.parameter.CalcAgreementCipherParameters;
import cn.geminis.crypto.csp.parameter.InitAgreementCipherParameters;

import java.math.BigInteger;

/**
 * @author Allen
 */
public class EmptyAgreement extends AbstractAgreement {

    public EmptyAgreement(PublicKey publicKey, PrivateKey privateKey) {
        super(publicKey);
    }

    @Override
    public void init(InitAgreementCipherParameters param) {
    }

    @Override
    public BigInteger calculateAgreement(CalcAgreementCipherParameters param) {
        return BigInteger.ZERO;
    }

    @Override
    public byte[] getSession() {
        return new byte[0];
    }

    @Override
    public void setSession(byte[] session) {

    }

    @Override
    public PublicKey getTempPublicKey() {
        return this.publicKey;
    }

    @Override
    public int getFieldSize() {
        return 64;
    }

    @Override
    public void close() {

    }
}
