package cn.geminis.crypto.csp.soft;

import cn.geminis.crypto.core.key.KeyPair;
import cn.geminis.crypto.core.key.PrivateKey;
import cn.geminis.crypto.core.key.PublicKey;
import cn.geminis.crypto.csp.KeyPairGenerator;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;

/**
 * @author Allen
 */
public abstract class AbstractSoftKeyPairGenerator implements KeyPairGenerator {

    protected AsymmetricCipherKeyPairGenerator generator;

    /**
     * 获取密钥OID
     *
     * @return 密钥OID
     */
    @Override
    public abstract String getObjectIdentifier();

    @Override
    public KeyPair generateKeyPair() {
        var keyPair = this.generator.generateKeyPair();
        return new KeyPair(new PublicKey(keyPair.getPublic()),
                new PrivateKey(keyPair.getPrivate()));
    }

    @Override
    public void close() {
    }

}
