package cn.geminis.crypto.csp.soft;

import cn.geminis.crypto.csp.AbstractDigest;

/**
 * @author Allen
 */
public abstract class AbstractSoftDigest extends AbstractDigest {

    private org.bouncycastle.crypto.Digest digest;

    public AbstractSoftDigest() {
        this.digest = this.createDigest();
    }

    /**
     * 创建内部摘要计算器
     *
     * @return 摘要计算器
     */
    protected abstract org.bouncycastle.crypto.Digest createDigest();

    @Override
    public String getAlgorithmName() {
        return this.digest.getAlgorithmName();
    }

    @Override
    public int getDigestSize() {
        return this.digest.getDigestSize();
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.digest.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        return this.digest.doFinal(out, outOff);
    }

    @Override
    public void reset() {
        this.digest.reset();
    }

    @Override
    public void close() {
    }

}
