package cn.geminis.crypto.csp.soft;

import cn.geminis.crypto.csp.AbstractBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.KeyParameter;

/**
 * @author Allen
 */
public abstract class AbstractSoftBlockCipher extends AbstractBlockCipher {

    private org.bouncycastle.crypto.BlockCipher cipher;
    private byte[] mainKey;

    public AbstractSoftBlockCipher(byte[] mainKey) {
        this.mainKey = mainKey;
        this.cipher = this.createBlockChiper();
    }

    /**
     * 创建内部加密器
     *
     * @return 加密器
     */
    protected abstract org.bouncycastle.crypto.BlockCipher createBlockChiper();

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        this.cipher.init(forEncryption, params);
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws IllegalStateException {
        return this.cipher.processBlock(in, inOff, out, outOff);
    }

    @Override
    public void reset() {
        this.cipher.reset();
    }

    @Override
    public CipherParameters createParams(byte[] key) {
        return new KeyParameter(key == null ? mainKey : key);
    }

    @Override
    public void close() {
    }
}
