package cn.geminis.crypto.csp;

import cn.geminis.crypto.core.key.KeyPair;

import java.io.Closeable;

/**
 * @author Allen
 */
public interface KeyPairGenerator extends Closeable {

    /**
     * 获取密钥OID
     *
     * @return 密钥OID
     */
    String getObjectIdentifier();

    /**
     * 产生密钥对
     *
     * @return 密钥对
     */
    KeyPair generateKeyPair();

}
