package cn.geminis.crypto.csp;

import cn.geminis.crypto.csp.parameter.InitMacCipherParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Mac;

import java.io.Closeable;

/**
 * @author Allen
 */
public abstract class AbstractMac implements Mac, Closeable {

    @Override
    public void init(CipherParameters params) {
        init((InitMacCipherParameters) params);
    }

    /**
     * 初始化参数
     *
     * @param params 密钥参数
     */
    public abstract void init(InitMacCipherParameters params);

    @Override
    public void update(byte in) {
        update(new byte[]{in}, 0, 1);
    }

}
