package cn.geminis.crypto.csp;

import java.io.Closeable;

/**
 * @author Allen
 */
public abstract class AbstractDigest implements org.bouncycastle.crypto.Digest, Closeable {

    /**
     * 获取算法OID
     *
     * @return 算法OID
     */
    public abstract String getAlgorithmOid();

    @Override
    public void update(byte in) {
        this.update(new byte[in], 0, 1);
    }

    public byte[] digest(byte[] data) {
        byte[] result = new byte[this.getDigestSize()];

        this.reset();
        this.update(data, 0, data.length);
        this.doFinal(result, 0);

        return result;
    }
}
