package cn.geminis.crypto.csp;

import cn.geminis.crypto.core.key.PublicKey;
import cn.geminis.crypto.csp.parameter.CalcAgreementCipherParameters;
import cn.geminis.crypto.csp.parameter.InitAgreementCipherParameters;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.CipherParameters;

import java.io.Closeable;
import java.math.BigInteger;

/**
 * @author puddi
 */
public abstract class AbstractAgreement implements BasicAgreement, Closeable {

    protected PublicKey publicKey;

    public AbstractAgreement(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    /**
     * 初始化参数
     *
     * @param param 私钥参数
     */
    public abstract void init(InitAgreementCipherParameters param);

    /**
     * 计算协商密钥
     *
     * @param param 公钥参数
     * @return 协商密钥
     */
    public abstract BigInteger calculateAgreement(CalcAgreementCipherParameters param);

    /**
     * 获得密钥协商会话
     *
     * @return 会话
     */
    public abstract byte[] getSession();

    /**
     * 设置会话
     *
     * @param session 会话
     */
    public abstract void setSession(byte[] session);

    /**
     * 获取临时公钥
     *
     * @return 临时公钥
     */
    public abstract PublicKey getTempPublicKey();

    @Override
    public void init(CipherParameters param) {
        init((InitAgreementCipherParameters) param);
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters param) {
        return calculateAgreement((CalcAgreementCipherParameters) param);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}
