package cn.geminis.crypto.core.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.style.BCStyle;

/**
 * @author puddi
 */
public class Utf8Style extends BCStyle {

    @Override
    protected ASN1Encodable encodeStringValue(ASN1ObjectIdentifier oid, String value) {

        if (BCStyle.C.equals(oid) || BCStyle.E.equals(oid)) {
            return new DERUTF8String(value);
        } else {
            return super.encodeStringValue(oid, value);
        }
    }

}
