package cn.geminis.crypto.core.x509;

import cn.geminis.core.util.DateUtils;
import org.bouncycastle.cert.X509CRLEntryHolder;
import org.bouncycastle.cert.X509CRLHolder;

import java.io.IOException;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author puddi
 */
public class Crl {

    private X509CRLHolder bcCrl;

    private String issuer;
    private LocalDateTime nextUpdate;
    private byte[] data;

    public String getIssuer() {
        return issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public LocalDateTime getNextUpdate() {
        return nextUpdate;
    }

    public void setNextUpdate(LocalDateTime nextUpdate) {
        this.nextUpdate = nextUpdate;
    }

    public byte[] getData() {
        return data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public Crl(byte[] data) {
        this.data = data;
        try {
            bcCrl = new X509CRLHolder(data);
        } catch (IOException e) {
            throw new RuntimeException("解析CRL内容错误", e);
        }
        issuer = bcCrl.getIssuer().toString();
    }

    public boolean checkSn(BigInteger sn, LocalDateTime time) {
        X509CRLEntryHolder holder = bcCrl.getRevokedCertificate(sn);
        if (Objects.isNull(holder)) {
            return true;
        }

        return holder.getRevocationDate().after(DateUtils.toDate(time));
    }

}
