package cn.geminis.crypto.core.util;

import cn.geminis.crypto.core.x509.X509Certificate;
import org.bouncycastle.cms.SignerId;

import java.util.List;

/**
 * @author puddi
 */
public class X509CertificateUtils {

    public static X509Certificate findCert(List<X509Certificate> certs, SignerId certId) {
        return certs.stream()
                .filter(cert -> cert.getSerialNumber().equals(certId.getSerialNumber()))
                .findFirst()
                .orElseThrow(() -> new RuntimeException("未找到证书，序列号：" + certId.getSerialNumber()));
    }

}
