package cn.geminis.crypto.core.util;

import java.math.BigInteger;
import java.util.UUID;
import cn.geminis.core.util.ByteUtils;

/**
 * @author Allen
 */
public class SerialNumberUtils {

    public static BigInteger create() {
        BigInteger serialNumber = BigInteger.valueOf(-1);
        while (serialNumber.compareTo(BigInteger.ZERO) < 0) {
            UUID id = UUID.randomUUID();
            serialNumber = new BigInteger(ByteUtils.fromUUID(id));
        }
        return serialNumber;
    }

    public static String toString(BigInteger serialNumber) {
        return serialNumber.toString(16);
    }

}
