package cn.geminis.crypto.core.util;

import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.PKCS7Padding;

/**
 * @author Allen
 */
public class ByteUtils {
    public static byte[] pkcs7Padding(byte[] data, int length) {
        PKCS7Padding padding = new PKCS7Padding();
        int fullLength = (data.length / length + 1) * length;
        byte[] newData = cn.geminis.core.util.ByteUtils.resize(data, fullLength);
        padding.addPadding(newData, data.length);
        return newData;
    }

    public static byte[] pkcs7Unpadding(byte[] data) {
        PKCS7Padding padding = new PKCS7Padding();
        try {
            int count = padding.padCount(data);
            return cn.geminis.core.util.ByteUtils.resize(data, data.length - count);
        } catch (InvalidCipherTextException e) {
            throw new RuntimeException("PKCS7填充解析错误", e);
        }
    }
}
