/*
 * Copyright 2015 the original author or authors.
 *  
 * Build date: 2015年4月23日
 */
package cn.gcsts.misky.gradle.webmodule


import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar
/**
 * @author lh83mail@126.com
 * @version 1.0.0
 */
class WebModuleTask extends Jar {
	public static final String SECTION_NAME = "Web-Module";
	public static final String DEFAULT_CLASSIFIER = "webmodule";
	
	def String moduleName = "unkown";
	private final DefaultCopySpec webviewSpec

	@Override
	protected CopySpecInternal createRootSpec() {
		CopySpecInternal spec =  super.createRootSpec()
		spec.addChild().into("webviews") {
			from(project.webAppDir) {
				include "jspviews/${moduleName}/**"
				include "resources/${moduleName}/**"
			}
		}


		spec.addChild().into("java-resources") {
			from ("${project.buildDir}/resources/main") {
				include "${moduleName}/**"
			}
		}

		return spec;
	}
	
	/* (non-Javadoc)
	 * @see org.gradle.api.tasks.bundling.AbstractArchiveTask#getClassifier()
	 */
	@Override
	public String getClassifier() {
		def classifier = super.getClassifier();
		return (classifier == null || classifier.empty) ? DEFAULT_CLASSIFIER: classifier;
	}
	
	
	/* (non-Javadoc)
	 * @see org.gradle.api.tasks.bundling.Jar#getManifest()
	 */
	@Override
	public Manifest getManifest() {
		Manifest manifest = super.getManifest();
		if (manifest == null) {
			manifest = new DefaultManifest(null);
		}

		manifest.attributes(
			"Module-Name" : moduleName,
			"Module-Version" : getVersion(),
			WebModuleTask.SECTION_NAME
		);
		return manifest;
	}
}
