package cn.gcsts.misky.gradle.webmodule

import static org.gradle.api.Task.*

import org.gradle.api.Project
import org.gradle.api.Plugin
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.WarPlugin

class WebModulePlugin implements Plugin<Project> {
	public final static String WEB_MOUDLE_NAME = "webmodule";
	public final static String CLENA_WEB_MOUDLE_NAME = "cleanWebmodule";
	
    void apply(Project target) {
    
    	target.plugins.apply WarPlugin
    	
    	target.configurations {
    		webmodules
    	}
        
        target.task(
        	"dependsOn" : target.configurations.webmodules,
        	"description" : '安装依赖的Web资源到项目中',
        	"type": InstallWebModuleTask,
        	'installWebModules') 
        
        //
        configCreateTask(target)
		
		configWebModuleTask(target);
        
		configCleanWebModuleTask(target);
    }
	
	void configCleanWebModuleTask(Project target) {
			target.task(
				"description" : '清理WebModule',
				"type": CleanWebModuleTask,
				CLENA_WEB_MOUDLE_NAME) ;
		
	}
	
	void configWebModuleTask(Project target) {
	
		target.task(
			"description" : '生成WebModule',
			"group" : 'build',
			"type": WebModuleTask,
			WEB_MOUDLE_NAME) ;
	
	}
    
    void configCreateTask(Project target) {
    
    	 target.task("description" : '创建项目默认目录结构',
			 "group" : "help",
        	'createProjectDirectory') << {
			
        	target.sourceSets*.allSource*.srcDirs*.each { it.mkdirs(); }
        	
        	if (target.hasProperty('webAppDirName')) {
				target.mkdir target.webAppDirName
			}
        } 
    }
}