/*
 * Copyright 2015 the original author or authors.
 *  
 * Build date: 2015年4月23日
 */
package cn.gcsts.misky.gradle.webmodule


import org.gradle.api.DefaultTask;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar

/**
 * @author lh83mail@126.com
 * @version 1.0.0
 */
class CleanWebModuleTask extends DefaultTask {

	@TaskAction
	protected void process() {
		
		project.configurations.webmodules.each { File f ->
			
			if (f == null || !f.exists()) return;
			 
			def jar = new java.util.jar.JarFile(f)
			def attrs = jar.manifest.getAttributes(WebModuleTask.SECTION_NAME);
			
			// 不是webmodule
			if (attrs == null || attrs.isEmpty()) {
				return;	
			}
			
			def moduelName = attrs.getValue("Module-Name");
			
			// 不是web module
			if (moduelName == null || moduelName.empty) {
				return;
			}
			
			project.delete(
				"${project.webAppDirName}/jspviews/${moduelName}",
				"${project.webAppDirName}/resources/${moduelName}",
				"${project.sourceSets.main.resources.srcDirs[0]}/${moduelName}",
			) 
		}
	}
	
}
