/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.serializer;

import cn.fyupeng.serializer.CJsonSerializer;
import cn.fyupeng.serializer.FurySerializer;
import cn.fyupeng.serializer.HessianSerializer;
import cn.fyupeng.serializer.JsonSerializer;
import cn.fyupeng.serializer.KryoSerializer;
import cn.fyupeng.serializer.SJsonSerializer;

public interface CommonSerializer {
    public static final Integer KRYO_SERIALIZER = 0;
    public static final Integer JSON_SERIALIZER = 1;
    public static final Integer HESSIAN_SERIALIZER = 2;
    public static final Integer JFURY_SERIALIZER = 3;
    public static final Integer GFURY_SERIALIZER = 4;
    public static final Integer XFURY_SERIALIZER = 5;
    public static final Integer CJSON_SERIALIZER = 6;
    public static final Integer SJSON_SERIALIZER = 7;
    public static final Integer DEFAULT_SERIALIZER = KRYO_SERIALIZER;

    public byte[] serialize(Object var1);

    public Object deserialize(byte[] var1, Class<?> var2);

    public int getCode();

    public static CommonSerializer getByCode(int code) {
        switch (code) {
            case 0: {
                return new KryoSerializer();
            }
            case 1: {
                return new JsonSerializer();
            }
            case 2: {
                return new HessianSerializer();
            }
            case 3: {
                return new FurySerializer(JFURY_SERIALIZER);
            }
            case 4: {
                return new FurySerializer(GFURY_SERIALIZER);
            }
            case 5: {
                return new FurySerializer(XFURY_SERIALIZER);
            }
            case 6: {
                return new CJsonSerializer();
            }
            case 7: {
                return new SJsonSerializer();
            }
        }
        return null;
    }
}

