/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.loadbalancer;

import cn.fyupeng.exception.RpcException;
import cn.fyupeng.exception.ServiceNotFoundException;
import cn.fyupeng.loadbalancer.LoadBalancer;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class RoundRobinLoadBalancer
implements LoadBalancer {
    private final AtomicLong idx = new AtomicLong();

    @Override
    public <T> T selectService(List<T> services) throws RpcException {
        if (services.size() == 0) {
            throw new ServiceNotFoundException("service instances size is zero, can't provide service! please start server first!");
        }
        int num = (int)(this.idx.getAndIncrement() % (long)services.size());
        return services.get(num < 0 ? -num : num);
    }

    @Override
    public String selectNode(String[] nodes) throws RpcException {
        if (nodes.length == 0) {
            throw new ServiceNotFoundException("service instances size is zero, can't provide service! please start server first!");
        }
        int num = (int)(this.idx.getAndIncrement() % (long)nodes.length);
        return nodes[num < 0 ? -num : num];
    }
}

