/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.idworker;

import cn.fyupeng.config.AbstractRedisConfiguration;
import cn.fyupeng.idworker.exception.WorkerIdCantApplyException;
import cn.fyupeng.util.IpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerIdServer {
    private static final Logger log = LoggerFactory.getLogger(WorkerIdServer.class);
    private static long workerId = 0L;
    private static String redisClientWay = "";
    private static AbstractRedisConfiguration redisClientConfig = AbstractRedisConfiguration.getClientConfig();

    public static void preLoad() {
    }

    public static long getWorkerId(int serverCode) {
        switch (serverCode) {
            case 0: {
                return Long.parseLong(redisClientConfig.getWorkerIdForHostName(IpUtils.getPubIpAddr()));
            }
        }
        return Long.parseLong(redisClientConfig.getWorkerIdForHostName(IpUtils.getPubIpAddr()));
    }

    static {
        if (workerId == 0L) {
            workerId = 1L;
            String hostName = IpUtils.getPubIpAddr();
            if (redisClientConfig.existsWorkerId(hostName)) {
                workerId = Long.parseLong(redisClientConfig.getWorkerIdForHostName(hostName));
            } else {
                int h = hostName.hashCode() & Integer.MAX_VALUE;
                h ^= h >>> 16;
                int id = h % 1024;
                workerId = id;
                if (!redisClientConfig.existsWorkerId(hostName)) {
                    long oldWorkerId = workerId;
                    while (redisClientConfig.existsWorkerIdSet(workerId)) {
                        if ((workerId = (workerId + 1L) % 1024L) != oldWorkerId) continue;
                        log.error("machine code node cannot be applied, nodes number has reached its maximum value");
                        throw new WorkerIdCantApplyException(String.format("Machine code node cannot be applied, Nodes number has reached its maximum value", new Object[0]));
                    }
                    redisClientConfig.setWorkerId(hostName, workerId);
                    redisClientConfig.setWorkerIdSet(workerId);
                }
            }
        }
    }
}

