/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.idworker;

import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdWorker {
    protected long epoch = 1288834974657L;
    protected long workerIdBits = 10L;
    protected long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.workerIdBits;
    protected long sequenceBits;
    protected long workerIdShift = this.sequenceBits = 12L;
    protected long timestampLeftShift = this.sequenceBits + this.workerIdBits;
    protected long sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.sequenceBits;
    protected long lastMillis = -1L;
    protected final long workerId;
    protected long sequence = 0L;
    protected boolean isLockBack = false;
    protected boolean isFirstLockBack = true;
    protected long lockBackTimestamp;
    protected Logger logger = LoggerFactory.getLogger(IdWorker.class);

    public IdWorker(long workerId) {
        this.workerId = this.checkWorkerId(workerId);
    }

    public long getEpoch() {
        return this.epoch;
    }

    private long checkWorkerId(long workerId) {
        if (workerId > this.maxWorkerId || workerId < 0L) {
            int rand = new SecureRandom().nextInt((int)this.maxWorkerId + 1);
            this.logger.warn("worker Id can't be greater than {} or less than 0, use a random {}", (Object)this.maxWorkerId, (Object)rand);
            return rand;
        }
        return workerId;
    }

    public synchronized long nextId() {
        long timestamp = this.millisGen();
        if (this.isLockBack && timestamp > this.lastMillis) {
            this.logger.info(">> Clock dial back to normal <<");
            this.isFirstLockBack = true;
            this.isLockBack = false;
        }
        if (timestamp < this.lastMillis) {
            timestamp = this.lastMillis;
            this.isLockBack = true;
            if (this.isFirstLockBack) {
                this.logger.warn(">> Clock callback occurs when the ID is generated <<");
                this.lockBackTimestamp = this.lastMillis;
                this.isFirstLockBack = false;
            }
        }
        if (timestamp == this.lastMillis) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.isLockBack ? ++this.lastMillis : this.tilNextMillis(this.lastMillis);
            }
        } else {
            this.sequence = 0L;
        }
        if (!this.isLockBack) {
            this.lastMillis = timestamp;
        }
        long diff = timestamp - this.getEpoch();
        return diff << (int)this.timestampLeftShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    protected long tilNextMillis(long lastMillis) {
        long millis = this.millisGen();
        while (millis <= lastMillis) {
            millis = this.millisGen();
        }
        return millis;
    }

    protected long millisGen() {
        return System.currentTimeMillis();
    }

    public long getLastMillis() {
        return this.lastMillis;
    }

    public long getWorkerId() {
        return this.workerId;
    }
}

