/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.factory;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolFactory {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolFactory.class);
    private static final int FIXED_CORE_POOL_SIZE = 200;
    private static final int FIXED_MAXIMUM_POOL_SIZE = 200;
    private static final int FIXED_KEEP_ALIVE_TIMEOUT = 0;
    private static final int CACHE_CORE_POOL_SIZE = 0;
    private static final int CACHE_MAXIMUM_POOL_SIZE = Integer.MAX_VALUE;
    private static final int CACHE_KEEP_ALIVE_TIMEOUT = 60000;
    public static final int FIXED_THREAD_POOL = 0;
    public static final int DEFAULT_THREAD_POOL = 1;
    public static final int CACHE_THREAD_POOL = 2;
    private static Map<String, ExecutorService> threadPoolsMap = new ConcurrentHashMap<String, ExecutorService>();

    public static void main(String[] args) {
        ExecutorService test = ThreadPoolFactory.createDefaultThreadPool("test");
        System.out.println(test);
    }

    public static ExecutorService createDefaultThreadPool(String threadNamePrefix) {
        return ThreadPoolFactory.createFixedThreadPool(threadNamePrefix, 0, false);
    }

    public static ExecutorService createThreadPool(int schema, String threadNamePrefix, int queues) {
        return ThreadPoolFactory.createThreadPool0(schema, threadNamePrefix, queues, false);
    }

    public static ExecutorService createThreadPool(int schema, String threadNamePrefix, int queues, boolean daemon) {
        return ThreadPoolFactory.createThreadPool0(schema, threadNamePrefix, queues, daemon);
    }

    private static ExecutorService createThreadPool0(int schema, String threadNamePrefix, int queues, Boolean daemon) {
        ExecutorService pool = null;
        switch (schema) {
            case 0: 
            case 1: {
                pool = threadPoolsMap.computeIfAbsent(threadNamePrefix, k -> ThreadPoolFactory.createFixedThreadPool(threadNamePrefix, queues, daemon));
                break;
            }
            case 2: {
                pool = threadPoolsMap.computeIfAbsent(threadNamePrefix, k -> ThreadPoolFactory.createCacheThreadPool(threadNamePrefix, queues, daemon));
            }
        }
        if (pool != null && (pool.isShutdown() || pool.isTerminated())) {
            threadPoolsMap.remove(threadNamePrefix);
            pool = schema == 0 ? ThreadPoolFactory.createFixedThreadPool(threadNamePrefix, queues, daemon) : (schema == 2 ? ThreadPoolFactory.createCacheThreadPool(threadNamePrefix, queues, daemon) : ThreadPoolFactory.createFixedThreadPool(threadNamePrefix, queues, daemon));
            threadPoolsMap.put(threadNamePrefix, pool);
        }
        return pool;
    }

    private static ExecutorService createFixedThreadPool(String threadNamePrefix, int queues, boolean daemon) {
        SynchronousQueue<Runnable> workQueue = queues == 0 ? new SynchronousQueue() : (queues < 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(queues));
        ThreadFactory threadFactory = ThreadPoolFactory.createThreadFactory(threadNamePrefix, daemon);
        return new ThreadPoolExecutor(200, 200, 0L, TimeUnit.MILLISECONDS, workQueue, threadFactory);
    }

    private static ExecutorService createCacheThreadPool(String threadNamePrefix, int queues, boolean daemon) {
        SynchronousQueue<Runnable> workQueue = queues == 0 ? new SynchronousQueue() : (queues < 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(queues));
        ThreadFactory threadFactory = ThreadPoolFactory.createThreadFactory(threadNamePrefix, daemon);
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60000L, TimeUnit.MILLISECONDS, workQueue, threadFactory);
    }

    public static void shutdownAll() {
        log.info("close all ThreadPool now ...");
        threadPoolsMap.entrySet().parallelStream().forEach(entry -> {
            ExecutorService executorService = (ExecutorService)entry.getValue();
            executorService.shutdown();
            log.info("close threadPool [{}] [{}]", entry.getKey(), (Object)executorService.isTerminated());
            try {
                executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error("failed to close thread pool: ", (Throwable)e);
                executorService.shutdownNow();
            }
        });
        log.info("threadPool closed successfully");
    }

    private static ThreadFactory createThreadFactory(String threadNamePrefix, Boolean daemon) {
        if (threadNamePrefix != null) {
            if (daemon != null) {
                return new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "-%d").setDaemon(daemon.booleanValue()).build();
            }
            return new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "-%d").build();
        }
        return Executors.defaultThreadFactory();
    }
}

