/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.config;

import cn.fyupeng.config.Configuration;
import cn.fyupeng.enums.LoadBalancerCode;
import cn.fyupeng.exception.RpcException;
import cn.fyupeng.loadbalancer.LoadBalancer;
import cn.fyupeng.util.IpUtils;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfiguration
implements Configuration {
    private static final Logger log = LoggerFactory.getLogger(NacosConfiguration.class);
    private static final Set<String> serviceNames = new HashSet<String>();
    private static LoadBalancer loadBalancer;
    private static String nacosServerAddr;
    private static NamingService namingService;
    private static InetSocketAddress inetSocketAddress;
    private static String nacosUseCluster;
    private static String[] nacosNodes;
    private static String nacosBalancer;

    private static NamingService getNacosNamingService(String newAddress) {
        try {
            return NamingFactory.createNamingService((String)(newAddress != null ? newAddress : nacosServerAddr));
        }
        catch (NacosException e) {
            log.error("error occurred when connecting to nacos server: ", (Throwable)e);
            return null;
        }
    }

    public static List<Instance> getAllInstance(String serviceName) throws RpcException, NacosException {
        if (nacosNodes.length != 1 && namingService.getServerStatus() == "DOWN") {
            String node = loadBalancer.selectNode(nacosNodes);
            log.info("disaster recovery switch occurred in registration center[{}]", (Object)nacosServerAddr);
            namingService = NacosConfiguration.getNacosNamingService(node);
            if (namingService.getServerStatus() == "UP") {
                nacosServerAddr = node;
                log.info("The registry node switches to {}", (Object)nacosServerAddr);
                return namingService.getAllInstances(serviceName);
            }
            log.warn("naocs server [{}] is unavalable", (Object[])nacosNodes);
        }
        return namingService.getAllInstances(serviceName);
    }

    public static List<Instance> getAllInstance(String serviceName, String groupName) throws NacosException, RpcException {
        if (nacosNodes.length != 1 && namingService.getServerStatus() == "DOWN") {
            String node = loadBalancer.selectNode(nacosNodes);
            log.info("disaster recovery switch occurred in registration center[{}]", (Object)nacosServerAddr);
            namingService = NacosConfiguration.getNacosNamingService(node);
            if (namingService.getServerStatus() == "UP") {
                nacosServerAddr = node;
                log.info("The registry node switches to {}", (Object)nacosServerAddr);
                return namingService.getAllInstances(serviceName, groupName);
            }
            log.warn("naocs server [{}] is unavalable", (Object[])nacosNodes);
        }
        return namingService.getAllInstances(serviceName, groupName);
    }

    public static void registerService(String serviceName, InetSocketAddress address) throws NacosException {
        namingService.registerInstance(serviceName, address.getHostName(), address.getPort());
        log.info("host[{}], service[{}] has been registered on Register Center", (Object)address.getHostName(), (Object)serviceName);
        inetSocketAddress = address;
        serviceNames.add(serviceName);
    }

    public static void registerService(String serviceName, String groupName, InetSocketAddress address) throws NacosException {
        namingService.registerInstance(serviceName, groupName, address.getHostName(), address.getPort());
        log.info("host[{}], service[{}] has been registered on Register Center", (Object)address.getHostName(), (Object)serviceName);
        inetSocketAddress = address;
        serviceNames.add(serviceName);
    }

    public static void clearRegistry() {
        if (!serviceNames.isEmpty() && inetSocketAddress != null) {
            String hostname = inetSocketAddress.getHostName();
            int port = inetSocketAddress.getPort();
            for (String serviceName : serviceNames) {
                try {
                    serviceNames.remove(serviceName);
                    namingService.deregisterInstance(serviceName, hostname, port);
                }
                catch (NacosException e) {
                    log.error("Failed to cancel service:{}, info:{}", (Object)serviceName, (Object)e);
                }
            }
            log.info("All services on the nacos service have been cleaned up successfully");
        }
    }

    static {
        nacosServerAddr = "127.0.0.1:8848";
        nacosUseCluster = "";
        nacosNodes = null;
        nacosBalancer = "round";
        Properties p = new Properties();
        String currentWorkPath = System.getProperty("user.dir");
        Object is = null;
        ResourceBundle configResource = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(currentWorkPath + "/config/resource.properties"));){
            configResource = new PropertyResourceBundle(bufferedReader);
            nacosUseCluster = configResource.getString("cn.fyupeng.nacos.cluster.use");
            if ("false".equals(nacosUseCluster) || "default".equals(nacosUseCluster) || StringUtils.isBlank((String)nacosUseCluster)) {
                log.info("begin start with single mode");
                nacosNodes = new String[1];
                try {
                    NacosConfiguration.nacosNodes[0] = configResource.getString("cn.fyupeng.nacos.register-addr");
                }
                catch (MissingResourceException registerAddException) {
                    NacosConfiguration.nacosNodes[0] = nacosServerAddr;
                    log.warn("nacos register address attribute is missing");
                    log.info("use default register address : " + nacosServerAddr);
                }
            } else {
                if ("true".equals(nacosUseCluster)) {
                    log.info("cluster mode attribute is true and start with cluster mode");
                    try {
                        nacosBalancer = configResource.getString("cn.fyupeng.nacos.cluster.load-balancer");
                    }
                    catch (MissingResourceException loadBalancerException) {
                        log.info("nacos property attribute is missing: {}", (Object)loadBalancerException.getMessage());
                        log.info("use default loadBalancer : " + nacosBalancer);
                    }
                    try {
                        nacosNodes = configResource.getString("cn.fyupeng.nacos.cluster.nodes").split("[;,|]");
                    }
                    catch (MissingResourceException clusternacosNodesException) {
                        log.error("nacos cluster nacosNodes attribute is missing: ", (Throwable)clusternacosNodesException);
                        throw new RuntimeException("nacos cluster nacosNodes attribute is missing!");
                    }
                }
                throw new RuntimeException("nacos cluster mode attribute is illegal!");
            }
            log.info("read resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
        }
        catch (MissingResourceException clusterUseException) {
            log.warn("nacos cluster use attribute is missing");
            log.info("begin start with default single mode");
            nacosNodes = new String[1];
            try {
                String nacosRegisterAddr = configResource.getString("cn.fyupeng.nacos.register-addr");
                NacosConfiguration.nacosNodes[0] = StringUtils.isBlank((String)nacosRegisterAddr) ? nacosServerAddr : nacosRegisterAddr;
            }
            catch (MissingResourceException registerAddException) {
                NacosConfiguration.nacosNodes[0] = nacosServerAddr;
                log.warn("nacos register address attribute is missing");
                log.info("use default register address : " + nacosServerAddr);
            }
        }
        catch (IOException ioException) {
            log.info("not found resource from resource path: {}", (Object)(currentWorkPath + "/config/resource.properties"));
            try {
                ResourceBundle resource = ResourceBundle.getBundle("resource");
                try {
                    nacosUseCluster = resource.getString("cn.fyupeng.nacos.cluster.use");
                    if ("false".equals(nacosUseCluster) || "default".equals(nacosUseCluster) || StringUtils.isBlank((String)nacosUseCluster)) {
                        log.info("begin start with default single mode");
                        nacosNodes = new String[1];
                        try {
                            String nacosRegisterAddr = resource.getString("cn.fyupeng.nacos.register-addr");
                            NacosConfiguration.nacosNodes[0] = StringUtils.isBlank((String)nacosRegisterAddr) ? nacosServerAddr : nacosRegisterAddr;
                        }
                        catch (MissingResourceException registerAddException) {
                            NacosConfiguration.nacosNodes[0] = nacosServerAddr;
                            log.warn("nacos register address attribute is missing");
                            log.info("use default register address : " + nacosServerAddr);
                        }
                    }
                    if ("true".equals(nacosUseCluster)) {
                        log.info("cluster mode attribute is true and start with cluster mode");
                        try {
                            nacosBalancer = resource.getString("cn.fyupeng.nacos.cluster.load-balancer");
                        }
                        catch (MissingResourceException loadBalancerException) {
                            log.info("nacos property attribute is missing: {}", (Object)loadBalancerException.getMessage());
                            log.info("use default loadBalancer : " + nacosBalancer);
                        }
                        try {
                            nacosNodes = resource.getString("cn.fyupeng.nacos.cluster.nodes").split("[;,|]");
                        }
                        catch (MissingResourceException clusternacosNodesException) {
                            log.error("nacos cluster nacosNodes attribute is missing: ", (Throwable)clusternacosNodesException);
                            throw new RuntimeException("nacos cluster nacosNodes attribute is missing!");
                        }
                    }
                    throw new RuntimeException("nacos cluster mode attribute is illegal!");
                }
                catch (MissingResourceException clusterUseException) {
                    log.info("cluster mode attribute is missing and start with single mode");
                    nacosNodes = new String[1];
                    NacosConfiguration.nacosNodes[0] = resource.getString("cn.fyupeng.nacos.register-addr");
                }
            }
            catch (MissingResourceException resourceException) {
                log.info("not found resource from resource path: {}", (Object)"resource.properties");
                log.info("Register center bind with default address {}", (Object)nacosServerAddr);
            }
        }
        log.info("read resource from resource path: {}", (Object)"resource.properties");
        log.info("------------ nacos Configuration \u3010 begin \u3011 ------------");
        log.info("nacosUseCluster: [{}]", (Object)nacosUseCluster);
        log.info("nacosNodes: [{}]", (Object[])nacosNodes);
        log.info("nacosBalancer: [{}]", (Object)nacosBalancer);
        log.info("------------ nacos Configuration \u3010 end \u3011 ------------");
        int pre = -1;
        String host = "";
        Integer port = 0;
        String node = null;
        if ("random".equals(nacosBalancer)) {
            loadBalancer = LoadBalancer.getByCode(LoadBalancerCode.RANDOM.getCode());
            log.info("use { {} } loadBalancer", (Object)loadBalancer.getClass().getName());
        } else if ("round".equals(nacosBalancer)) {
            loadBalancer = LoadBalancer.getByCode(LoadBalancerCode.ROUNDROBIN.getCode());
            log.info("use { {} } loadBalancer", (Object)loadBalancer.getClass().getName());
        } else {
            log.error("naocs cluster loadBalancer attribute is illegal!");
            throw new RuntimeException("naocs cluster loadBalancer attribute is illegal!");
        }
        do {
            try {
                node = loadBalancer.selectNode(nacosNodes);
                log.info("waiting for connection to the registration center...");
                pre = node.indexOf(":");
                if (pre > 0 && pre == node.lastIndexOf(":")) {
                    host = node.substring(0, pre);
                    boolean valid = IpUtils.valid(host);
                    if (valid) {
                        host = node.substring(0, pre);
                        port = Integer.parseInt(node.substring(pre + 1));
                        if (host.equals("localhost")) {
                            nacosServerAddr = "127.0.0.1:" + port;
                            continue;
                        }
                        nacosServerAddr = node;
                        continue;
                    }
                    log.error("wrong ip address: {}", (Object)node);
                    continue;
                }
                if (node.equals("")) continue;
                log.error("wrong ip address: {}", (Object)node);
            }
            catch (RpcException e) {
                e.printStackTrace();
            }
        } while ((namingService = NacosConfiguration.getNacosNamingService(null)).getServerStatus() == "DOWN");
        if (namingService.getServerStatus() == "UP") {
            log.info("Register center bind with address {}", (Object)node);
        } else if (nacosNodes != null && nacosNodes.length == 1) {
            log.error("SingleTon Register Center is down from {}", (Object)nacosServerAddr);
        } else if (nacosNodes != null && nacosNodes.length != 1) {
            log.error("Cluster Register Center is down from ");
            log.error("---");
            for (int i = 0; i < nacosNodes.length; ++i) {
                log.error("{}", (Object)nacosNodes[i]);
            }
            log.error("---");
        } else {
            log.error("Service occupy Internal Errors");
        }
    }
}

