/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.config;

import cn.fyupeng.config.AbstractRedisConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class JRedisConfiguration
extends AbstractRedisConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JRedisConfiguration.class);
    private Object lock = new Object();
    private Jedis jedis;

    @Override
    public synchronized JRedisConfiguration configure() {
        if (this.jedis == null) {
            if ("false".equals(redisServerAuth)) {
                this.jedis = new Jedis(redisServerHost, redisServerPort.intValue());
            } else {
                this.jedis = new Jedis(redisServerHost, redisServerPort.intValue());
                this.jedis.auth(redisServerPwd);
            }
        }
        return this;
    }

    @Override
    public boolean exists(String key) {
        return this.jedis.exists(key);
    }

    @Override
    public void set(String key, String value) {
        this.jedis.set(key, value);
    }

    @Override
    public String get(String key) {
        return this.jedis.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsWorkerId(String hostName) {
        Object object = this.lock;
        synchronized (object) {
            return this.jedis.exists("worker-ids:" + hostName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWorkerIdForHostName(String hostName) {
        Object object = this.lock;
        synchronized (object) {
            String value = this.jedis.get("worker-ids:" + hostName);
            log.debug("getForHostName key[{}] - value[{}]", (Object)hostName, (Object)value);
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWorkerId(String hostName, long workerId) {
        Object object = this.lock;
        synchronized (object) {
            log.debug("setWorkerId key[{}] - value[{}]", (Object)hostName, (Object)workerId);
            this.jedis.set("worker-ids:" + hostName, String.valueOf(workerId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remWorkerId(String hostName) {
        Object object = this.lock;
        synchronized (object) {
            log.debug("remWorkerId key[{}]", (Object)hostName);
            String workerId = this.getWorkerIdForHostName(hostName);
            this.jedis.del("worker-ids:" + hostName);
            if (workerId != null) {
                this.jedis.srem("worker-ids-set", new String[]{workerId});
            }
        }
    }

    @Override
    public void asyncRemWorkerId(String hostName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean existsWorkerIdSet(long workerId) {
        return this.jedis.sismember("worker-ids-set", String.valueOf(workerId));
    }

    @Override
    public void setWorkerIdSet(long workerId) {
        log.debug("setWorkerIdSet set[{}] - value[{}]", (Object)"worker-ids-set", (Object)workerId);
        this.jedis.sadd("worker-ids-set", new String[]{String.valueOf(workerId)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsRetryResult(String retryRequestId) {
        Object object = this.lock;
        synchronized (object) {
            return this.jedis.exists("retry-req-ids:" + retryRequestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResultForRetryRequestId2String(String retryRequestId) {
        Object object = this.lock;
        synchronized (object) {
            String value = this.jedis.get("retry-req-ids:" + retryRequestId);
            log.debug("getForRetryRequestId key[{}] - value[{}]", (Object)retryRequestId, (Object)value);
            return value;
        }
    }

    @Override
    public byte[] getResultForRetryRequestId2Bytes(String retryRequestId) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRetryRequestResultByString(String retryRequestId, String result) {
        Object object = this.lock;
        synchronized (object) {
            log.debug("setRetryRequestResult key[{}]- value[{}]", (Object)retryRequestId, (Object)result);
            this.jedis.set("retry-req-ids:" + retryRequestId, result, "NX", "EX", 60);
        }
    }

    @Override
    public void setRetryRequestResultByBytes(String retryRequestId, byte[] result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void asyncSet(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void asyncSetWorkerIdSet(long workerId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void asyncSetWorkerId(String hostName, long workerId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void asyncSetRetryRequestResult(String retryRequestId, byte[] result) {
        throw new UnsupportedOperationException();
    }
}

