/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.protocol;

import java.io.Serializable;
import java.util.Arrays;

public class RpcRequest
implements Serializable {
    private String requestId;
    private String interfaceName;
    private String methodName;
    private Object[] parameters;
    private Class<?>[] paramTypes;
    private Class<?> returnType;
    private String group;
    private Boolean heartBeat = false;

    public RpcRequest() {
    }

    public RpcRequest(Builder builder) {
        this.requestId = builder.requestId;
        this.interfaceName = builder.interfaceName;
        this.methodName = builder.methodName;
        this.parameters = builder.parameters;
        this.paramTypes = builder.paramTypes;
        this.returnType = builder.returnType;
        this.heartBeat = builder.heartBeat;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public Class<?>[] getParamTypes() {
        return this.paramTypes;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Boolean getHeartBeat() {
        return this.heartBeat;
    }

    public void setHeartBeat(Boolean heartBeat) {
        this.heartBeat = heartBeat;
    }

    public String toString() {
        return "RpcRequest{requestId='" + this.requestId + '\'' + ", interfaceName='" + this.interfaceName + '\'' + ", methodName='" + this.methodName + '\'' + ", parameters=" + Arrays.toString(this.parameters) + ", paramTypes=" + Arrays.toString(this.paramTypes) + ", group='" + this.group + '\'' + ", heartBeat=" + this.heartBeat + '}';
    }

    public static final class Builder {
        private String requestId;
        private String interfaceName;
        private String methodName;
        private Object[] parameters;
        private Class<?>[] paramTypes;
        private Class<?> returnType;
        private Boolean heartBeat;

        public Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder interfaceName(String interfaceName) {
            this.interfaceName = interfaceName;
            return this;
        }

        public Builder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder parameters(Object[] parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder paramTypes(Class<?>[] paramTypes) {
            this.paramTypes = paramTypes;
            return this;
        }

        public Builder returnType(Class<?> returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder heartBeat(Boolean heartBeat) {
            this.heartBeat = heartBeat;
            return this;
        }

        public RpcRequest build() {
            return new RpcRequest(this);
        }
    }
}

