/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.util;

import cn.fyupeng.util.CitySN;
import cn.fyupeng.util.JsonUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);

    public static boolean valid(String ip) {
        if (ip.equals("localhost")) {
            return true;
        }
        String z = ip.replace(".", "");
        int x = ip.length() - z.length();
        int t = ip.indexOf("..");
        if (t < 0) {
            boolean y = z.matches("[0-9]+");
            if (!(y && Character.isDigit(ip.charAt(0)) && Character.isDigit(ip.charAt(ip.length() - 1)))) {
                return false;
            }
            if (x == 3) {
                int b = ip.indexOf(46);
                String c = ip.substring(0, ip.indexOf(46));
                int i = Integer.parseInt(c);
                String d = ip.substring(b + 1);
                int e = d.indexOf(46);
                String f = d.substring(0, e);
                int j = Integer.parseInt(f);
                String g = d.substring(e + 1);
                int h = g.indexOf(46);
                String l = g.substring(0, h);
                int k = Integer.parseInt(l);
                String m = g.substring(h + 1);
                int n = Integer.parseInt(m);
                return i >= 0 && i <= 255 && j >= 0 && j <= 255 && k >= 0 && k <= 255 && n >= 0 && n <= 255;
            }
            return false;
        }
        return false;
    }

    public static String getPubIpAddr() {
        try {
            URL url = new URL("http://pv.sohu.com/cityjson?ie=utf-8");
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            String s = "";
            StringBuffer sb = new StringBuffer("");
            String webContent = "";
            while ((s = br.readLine()) != null) {
                sb.append(s + "\r\n");
            }
            br.close();
            webContent = sb.toString();
            int start = webContent.indexOf("{");
            int end = webContent.indexOf("}") + 1;
            webContent = webContent.substring(start, end);
            CitySN target = JsonUtils.jsonToPojo(webContent, CitySN.class);
            return target.getCip();
        }
        catch (Exception e) {
            log.error("get public IP address error: {}", (Throwable)e);
            return "error";
        }
    }

    public static void main(String[] args) {
        String pubIpAddr = IpUtils.getPubIpAddr();
        System.out.println(pubIpAddr);
    }
}

