/*
 * Decompiled with CFR 0.152.
 */
package cn.fyupeng.loadbalancer;

import cn.fyupeng.exception.RpcException;
import cn.fyupeng.exception.ServiceNotFoundException;
import cn.fyupeng.loadbalancer.LoadBalancer;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.List;

public class RoundRobinLoadBalancer
implements LoadBalancer {
    private int index = 0;

    @Override
    public Instance selectService(List<Instance> instances) throws RpcException {
        if (instances.size() == 0) {
            throw new ServiceNotFoundException("service instances size is zero, can't provide service! please start server first!");
        }
        ++this.index;
        return instances.get(this.index %= instances.size());
    }

    @Override
    public String selectNode(String[] nodes) throws RpcException {
        if (nodes.length == 0) {
            throw new ServiceNotFoundException("service instances size is zero, can't provide service! please start server first!");
        }
        ++this.index;
        return nodes[this.index %= nodes.length];
    }
}

