/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.swagger.webflux;

import cn.fxbin.swagger.SwaggerProperties;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.gateway.config.GatewayProperties;
import org.springframework.cloud.gateway.discovery.DiscoveryLocatorProperties;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionRepository;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.HandlerFunction;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Primary
@Component
@EnableConfigurationProperties(value={SwaggerProperties.class})
@ConditionalOnClass(value={HandlerFunction.class})
public class SwaggerProvider
implements SwaggerResourcesProvider {
    private static final Logger log = LoggerFactory.getLogger(SwaggerProvider.class);
    private static final String API_URI = "/v2/api-docs";
    @Resource
    private GatewayProperties gatewayProperties;
    @Resource
    private DiscoveryLocatorProperties discoveryLocatorProperties;
    @Resource
    private RouteDefinitionRepository routeDefinitionRepository;
    @Resource
    private DiscoveryClient discoveryClient;

    public List<SwaggerResource> get() {
        ArrayList routeList = new ArrayList(this.gatewayProperties.getRoutes());
        this.routeDefinitionRepository.getRouteDefinitions().sort(Comparator.comparingInt(RouteDefinition::getOrder)).subscribe(routeList::add);
        return routeList.stream().distinct().flatMap(routeDefinition -> routeDefinition.getPredicates().stream().filter(predicateDefinition -> "Path".equalsIgnoreCase(predicateDefinition.getName())).map(predicateDefinition -> this.swaggerResource(routeDefinition.getId(), ((String)predicateDefinition.getArgs().get("_genkey_0")).replace("/**", API_URI)))).filter(swaggerResource -> {
            if (this.isDynamic()) {
                return this.discoveryClient.getServices().stream().anyMatch(serviceId -> serviceId.equalsIgnoreCase(swaggerResource.getName()));
            }
            return true;
        }).sorted(Comparator.comparing(SwaggerResource::getName)).distinct().collect(Collectors.toList());
    }

    private SwaggerResource swaggerResource(String name, String location) {
        log.info("name:{}, location:{}", (Object)name, (Object)location);
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setLocation(location);
        swaggerResource.setSwaggerVersion("2.0");
        return swaggerResource;
    }

    private boolean isDynamic() {
        return this.discoveryLocatorProperties.isEnabled();
    }
}

