/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.swagger.autoconfigure;

import cn.fxbin.swagger.SwaggerProperties;
import com.github.xiaoymin.knife4j.spring.annotations.EnableKnife4j;
import com.github.xiaoymin.knife4j.spring.configuration.Knife4jAutoConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.oas.annotations.EnableOpenApi;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.ApiKeyVehicle;

@EnableKnife4j
@EnableOpenApi
@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={Knife4jAutoConfiguration.class})
@ConditionalOnClass(value={Docket.class})
@Import(value={BeanValidatorPluginsConfiguration.class})
@EnableConfigurationProperties(value={SwaggerProperties.class})
@ConditionalOnMissingClass(value={"org.springframework.cloud.gateway.config.GatewayAutoConfiguration"})
@ConditionalOnProperty(prefix="spring.swagger", name={"enabled"}, havingValue="true")
public class SwaggerAutoConfiguration {
    private static final String BASE_PATH = "/**";
    public static final String APPLICATION_NAME = "spring.application.name";
    private static final List<String> DEFAULT_EXCLUDE_PATH = Arrays.asList("/**/error/**", "/**/actuator/**");
    @Resource
    private Environment environment;
    @Resource
    private SwaggerProperties properties;

    @Bean
    public Docket docket() {
        if (this.properties.getBasePath().isEmpty()) {
            this.properties.getBasePath().add(BASE_PATH);
        }
        if (this.properties.getExcludeBasePath().isEmpty()) {
            this.properties.getExcludeBasePath().addAll(DEFAULT_EXCLUDE_PATH);
        }
        ApiSelectorBuilder builder = new Docket(DocumentationType.SWAGGER_2).host(this.properties.getHost()).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)this.properties.getBasePackage()));
        this.properties.getBasePath().forEach(p -> builder.paths(PathSelectors.ant((String)p)));
        this.properties.getExcludeBasePath().forEach(p -> builder.paths(PathSelectors.ant((String)p).negate()));
        Docket docket = builder.build().pathMapping("/");
        if (this.properties.getAuthorization().getEnabled().booleanValue()) {
            docket.securitySchemes(Collections.singletonList(this.apiKey()));
            docket.securityContexts(Collections.singletonList(this.securityContext()));
        }
        return docket;
    }

    private ApiInfo apiInfo() {
        String applicationName = this.environment.getProperty(APPLICATION_NAME);
        String defaultName = Optional.ofNullable(applicationName).orElse("default") + "\u670d\u52a1";
        String title = Optional.ofNullable(this.properties.getTitle()).orElse(defaultName);
        String description = Optional.ofNullable(this.properties.getDescription()).orElse(defaultName);
        return new ApiInfoBuilder().title(title).description(description).version(this.properties.getVersion()).license(this.properties.getLicense()).licenseUrl(this.properties.getLicenseUrl()).termsOfServiceUrl(this.properties.getTermsOfServiceUrl()).contact(new Contact(this.properties.getContact().getName(), this.properties.getContact().getUrl(), this.properties.getContact().getEmail())).build();
    }

    private ApiKey apiKey() {
        return new ApiKey(this.properties.getAuthorization().getName(), this.properties.getAuthorization().getKeyName(), ApiKeyVehicle.HEADER.getValue());
    }

    private SecurityContext securityContext() {
        return new SecurityContext(this.defaultAuth(), PathSelectors.regex((String)this.properties.getAuthorization().getAuthRegex()), null, null);
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        return Collections.singletonList(SecurityReference.builder().reference(this.properties.getAuthorization().getName()).scopes(authorizationScopes).build());
    }
}

