/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.web.validator;

import cn.fxbin.bubble.fireworks.web.validator.EqualField;
import java.lang.reflect.Field;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class EqualFieldValidator
implements ConstraintValidator<EqualField, Object> {
    private static final Logger log = LoggerFactory.getLogger(EqualFieldValidator.class);
    private String source;
    private String target;

    public void initialize(EqualField constraintAnnotation) {
        this.source = constraintAnnotation.source();
        this.target = constraintAnnotation.target();
    }

    public boolean isValid(Object object, ConstraintValidatorContext context) {
        Class<?> clazz = object.getClass();
        Field srcField = ReflectionUtils.findField(clazz, (String)this.source);
        Field dstField = ReflectionUtils.findField(clazz, (String)this.target);
        try {
            if (srcField == null || dstField == null) {
                throw new ValidationException("\u53cd\u5c04\u83b7\u53d6\u53d8\u91cf\u5931\u8d25");
            }
            srcField.setAccessible(true);
            dstField.setAccessible(true);
            Object src = srcField.get(object);
            Object dst = dstField.get(object);
            if (src == null || dst == null) {
                return src == dst;
            }
            if (src == dst) {
                return true;
            }
            return src.equals(dst);
        }
        catch (Exception e) {
            log.warn("EqualFieldValidator \u6821\u9a8c\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }
}

