/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.web.handler;

import cn.fxbin.bubble.fireworks.core.exception.ServiceException;
import cn.fxbin.bubble.fireworks.core.model.Result;
import cn.fxbin.bubble.fireworks.core.model.ResultCode;
import cn.fxbin.bubble.fireworks.core.util.ObjectUtils;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class DefaultGlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultGlobalExceptionHandler.class);

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public Result<String> exceptionHandler(Exception exception) {
        log.warn("[Exception]", (Throwable)exception);
        return Result.failure((String)exception.getMessage());
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={ServiceException.class})
    public Result<String> exceptionHandler(ServiceException ex) {
        log.warn("[ServiceException]", (Throwable)ex);
        return Result.failure((int)(ex.getErrcode() == 0 ? ResultCode.FAILURE.getCode() : ex.getErrcode()), (String)ex.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<String> bodyValidExceptionHandler(MethodArgumentNotValidException exception) {
        List fieldErrors = exception.getBindingResult().getFieldErrors();
        log.warn("MethodArgumentNotValidException: {}", (Object)exception.getMessage());
        return Result.failure((String)((FieldError)fieldErrors.get(0)).getDefaultMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BindException.class})
    public Result<String> bindExceptionHandler(BindException exception) {
        String defaultMessage = exception.getGlobalError().getDefaultMessage();
        log.warn("BindException: {}", (Object)exception.getMessage());
        return Result.failure((String)(ObjectUtils.isEmpty((Object)defaultMessage) ? ResultCode.REQUEST_PARAM_VALIDATION_ERROR.getMsg() : defaultMessage));
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={JsonParseException.class})
    public Result<String> exceptionHandler(JsonParseException exception) {
        log.warn("JsonParseException: {}", (Object)exception.getMessage());
        return Result.failure((String)exception.getMessage());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={JsonMappingException.class})
    public Result<String> exceptionHandler(JsonMappingException exception) {
        log.warn("JsonMappingException: {}", (Object)exception.getMessage());
        return Result.failure((String)exception.getMessage());
    }
}

