/*
 * Decompiled with CFR 0.152.
 */
package cn.fxbin.bubble.fireworks.lanuch;

import cn.fxbin.bubble.fireworks.core.util.support.AppUtils;
import cn.fxbin.bubble.fireworks.core.util.support.Version;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.StringUtils;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ComponentScan(basePackages={"cn.fxbin.bubble.fireworks"})
@Configuration(proxyBeanMethods=false)
public class StartedEventListener {
    private static final Logger log = LoggerFactory.getLogger(StartedEventListener.class);
    private static final String APPLICATION_NAME = "spring.application.name";
    private static final String CONTEXT_PATH = "server.servlet.context-path";

    @Async
    @Order(value=0x7FFFFFFE)
    @EventListener(value={WebServerInitializedEvent.class})
    public void afterStart(WebServerInitializedEvent event) {
        WebServerApplicationContext context = event.getApplicationContext();
        Environment environment = context.getEnvironment();
        String appName = Optional.ofNullable(environment.getProperty(APPLICATION_NAME)).orElse("default");
        String contextPath = Optional.ofNullable(environment.getProperty(CONTEXT_PATH)).orElse("");
        int localPort = event.getWebServer().getPort();
        String profile = StringUtils.arrayToCommaDelimitedString((Object[])environment.getActiveProfiles());
        String startInfo = String.format("[%s]---\u542f\u52a8\u5b8c\u6210\uff0c\u5f53\u524d\u4f7f\u7528\u7684\u7aef\u53e3:[%d]\uff0c\u73af\u5883\u53d8\u91cf:[%s]", appName, localPort, profile);
        String url = this.hasKnife4jUi() ? String.format("http://localhost:%s%s/doc.html", localPort, contextPath) : (this.hasSpringfoxSwaggerUi() ? String.format("http://localhost:%s%s/swagger-ui/index.html", localPort, contextPath) : (this.hasSwagger2Ui() ? String.format("http://localhost:%s%s/swagger-ui.html", localPort, contextPath) : String.format("http://localhost:%s%s", localPort, contextPath)));
        String bannerText = this.buildBannerText(startInfo, url);
        if (log.isInfoEnabled()) {
            log.info(bannerText);
        } else {
            System.out.print(bannerText);
        }
    }

    String buildBannerText(String startInfo, String url) {
        StringBuilder bannerTextBuilder = new StringBuilder();
        bannerTextBuilder.append(AppUtils.LINE_SEPARATOR).append(AppUtils.LINE_SEPARATOR).append(" :: Spring Boot (v").append(SpringBootVersion.getVersion()).append(") : ").append("https://github.com/spring-projects/spring-boot").append(AppUtils.LINE_SEPARATOR).append(" :: Bubble Fireworks Project (v").append(Version.getVersion()).append(") : ").append("https://github.com/fxbin/bubble-fireworks").append(AppUtils.LINE_SEPARATOR).append(" :: \u542f\u52a8\u4fe1\u606f : (").append(startInfo).append(")").append(AppUtils.LINE_SEPARATOR).append(" :: \u8bbf\u95ee : ").append(url).append(AppUtils.LINE_SEPARATOR);
        return bannerTextBuilder.toString();
    }

    private boolean hasKnife4jUi() {
        try {
            ClassPathResource resource = new ClassPathResource("META-INF/resources/doc.html");
            return resource.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean hasSpringfoxSwaggerUi() {
        try {
            ClassPathResource resource = new ClassPathResource("META-INF/resources/webjars/springfox-swagger-ui/index.html");
            return resource.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean hasSwagger2Ui() {
        try {
            ClassPathResource resource = new ClassPathResource("META-INF/resources/swagger-ui.html");
            return resource.exists();
        }
        catch (Exception e) {
            return false;
        }
    }
}

