/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

public class TtlMDCAdapter
implements MDCAdapter {
    private static final ThreadLocal<Map<String, String>> copyOnThreadLocal = new TransmittableThreadLocal();
    private static final int WRITE_OPERATION = 1;
    private static final int MAP_COPY_OPERATION = 2;
    private static TtlMDCAdapter ttlMDCAdapter = new TtlMDCAdapter();
    final ThreadLocal<Integer> lastOperation = new ThreadLocal();

    public static TtlMDCAdapter getTtlMDCAdapter() {
        return ttlMDCAdapter;
    }

    private Integer getAndSetLastOperation(int op) {
        Integer lastOp = this.lastOperation.get();
        this.lastOperation.set(op);
        return lastOp;
    }

    private boolean wasLastOpReadOrNull(Integer lastOp) {
        return lastOp == null || lastOp == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> duplicateAndInsertNewMap(Map<String, String> oldMap) {
        Map<String, String> newMap = Collections.synchronizedMap(new HashMap());
        if (oldMap != null) {
            Map<String, String> map = oldMap;
            synchronized (map) {
                newMap.putAll(oldMap);
            }
        }
        copyOnThreadLocal.set(newMap);
        return newMap;
    }

    public void put(String key, String val) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        Map<String, String> oldMap = copyOnThreadLocal.get();
        Integer lastOp = this.getAndSetLastOperation(1);
        if (this.wasLastOpReadOrNull(lastOp) || oldMap == null) {
            Map<String, String> newMap = this.duplicateAndInsertNewMap(oldMap);
            newMap.put(key, val);
        } else {
            oldMap.put(key, val);
        }
    }

    public void remove(String key) {
        if (key == null) {
            return;
        }
        Map<String, String> oldMap = copyOnThreadLocal.get();
        if (oldMap == null) {
            return;
        }
        Integer lastOp = this.getAndSetLastOperation(1);
        if (this.wasLastOpReadOrNull(lastOp)) {
            Map<String, String> newMap = this.duplicateAndInsertNewMap(oldMap);
            newMap.remove(key);
        } else {
            oldMap.remove(key);
        }
    }

    public void clear() {
        this.lastOperation.set(1);
        copyOnThreadLocal.remove();
    }

    public String get(String key) {
        Map<String, String> map = copyOnThreadLocal.get();
        if (map != null && key != null) {
            return map.get(key);
        }
        return null;
    }

    public Map<String, String> getPropertyMap() {
        this.lastOperation.set(2);
        return copyOnThreadLocal.get();
    }

    public Set<String> getKeys() {
        Map<String, String> map = this.getPropertyMap();
        if (map != null) {
            return map.keySet();
        }
        return null;
    }

    public Map<String, String> getCopyOfContextMap() {
        Map<String, String> hashMap = copyOnThreadLocal.get();
        if (hashMap == null) {
            return null;
        }
        return new HashMap<String, String>(hashMap);
    }

    public void setContextMap(Map<String, String> contextMap) {
        this.lastOperation.set(1);
        Map<String, String> newMap = Collections.synchronizedMap(new HashMap());
        newMap.putAll(contextMap);
        copyOnThreadLocal.set(newMap);
    }

    static {
        MDC.mdcAdapter = ttlMDCAdapter;
    }
}

